withdrawals.controllers.module('create-modal',
	[],
	() => {
		return {
			vue: true,
			name: 'gx-create-modal',
			template: '#create-modal',
			parent: 'gx-withdrawals-overview',
			data: () => ({
				lang: {
					title: jse.core.lang.translate('create_modal_title', 'withdrawals'),
					text: jse.core.lang.translate('create_modal_text', 'withdrawals'),
					close: jse.core.lang.translate('create_modal_close', 'withdrawals'),
					confirm: jse.core.lang.translate('create_modal_confirm', 'withdrawals'),
					labels: {
						orderId: jse.core.lang.translate('create_modal_labels_order_id', 'withdrawals'),
					},
				},
				orderId: '',
				orderIdOk: true,
			}),
			methods: {
				checkOrderId() {
					if (this.orderId === '') {
						this.orderIdOk = true;
						return;
					}
					this.orderIdOk = Number.isInteger(parseInt(this.orderId)) && parseInt(this.orderId) > 0;
					this.orderId = isNaN(parseInt(this.orderId)) ? '' : parseInt(this.orderId);
				},
				confirm() {
					if (this.orderId !== '' && this.orderIdOk) {
						window.location = '../withdrawal.php?order_id='+this.orderId;
					}else if (this.orderIdOk) {
						window.location = '../withdrawal.php';
					}
				},
			},
			init: done => done()
		}
	});